---
generated_at: 2026-01-21 11:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-WASMFS Scratchpad画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/wasm/scratchpad-wasmfs.html` - メインHTMLファイル
- E-02: `ext/wasm/scratchpad-wasmfs.mjs` - テスト実行Workerスクリプト
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（No.20）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WASMFS/OPFS統合実験用ページ | E-01 行13-14 説明文 | ○ |
| C-02 | 結果は開発者コンソールに出力 | E-01 行19 "All stuff...happens in the dev console" | ○ |
| C-03 | WASMFSサポート付きビルドが必要 | E-01 行15-16 | ○ |
| C-04 | WorkerはES6モジュールとして起動 | E-01 行24-26 {type:'module'} | ○ |
| C-05 | sqlite3-wasmfs.mjsをインポート | E-02 行16 | ○ |
| C-06 | sqlite3_wasmfs_opfs_dir()で永続ディレクトリ取得 | E-02 行44 | ○ |
| C-07 | 永続ディレクトリあればDB作成 | E-02 行45-52 | ○ |
| C-08 | 永続ストレージなければ警告出力 | E-02 行47-48 stderr | ○ |
| C-09 | DBファイル名はfoo.db | E-02 行52 | ○ |
| C-10 | test1でCREATE TABLE/INSERT/SELECT | E-02 行26-35 | ○ |
| C-11 | INSERTはnew Date().getTime() | E-02 行30 | ○ |
| C-12 | SELECT COUNT(*)でデータ件数出力 | E-02 行32-33 | ○ |
| C-13 | 実行時間を出力 | E-02 行67 "Total test time" | ○ |
| C-14 | 機能No.1 SQLiteライブラリ初期化が関連 | E-04 行76 | ○ |
| C-15 | 機能No.43 OS抽象化層（VFS）が関連 | E-04 行77 | ○ |
| C-16 | db.close()でクローズ | E-02 行65 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] WASMFSサポート付きビルドが正しく生成されているか確認
- [ ] 永続ストレージ（OPFS）が有効な環境でテストが成功するか確認
- [ ] リロード後もDBデータが保持されているか確認
